---
title: Deploy a WAF managed ruleset in the dashboard for an account · Cloudflare
  Web Application Firewall (WAF) docs
description: To deploy a managed ruleset for a single zone, refer to Deploy a
  managed ruleset in the dashboard for a zone.
lastUpdated: 2025-09-03T16:11:55.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/account/managed-rulesets/deploy-dashboard/
  md: https://developers.cloudflare.com/waf/account/managed-rulesets/deploy-dashboard/index.md
---

Note

This feature requires an Enterprise plan with a paid add-on.

To deploy a managed ruleset for a single zone, refer to [Deploy a managed ruleset in the dashboard for a zone](https://developers.cloudflare.com/waf/managed-rules/deploy-zone-dashboard/).

## Deploy a managed ruleset

1. In the Cloudflare dashboard, go to the **WAF** page.

   [Go to **WAF**](https://dash.cloudflare.com/?to=/:account/application-security/waf)

2. Go to the **Managed rulesets** tab.

   ![Example WAF Managed Rules configuration in the Managed rulesets tab.](https://developers.cloudflare.com/_astro/managed-rulesets-dashboard.BxgYTxN0_Z1BXzxF.webp)

3. Select **Deploy** > **Deploy managed ruleset**.

4. Next to the managed ruleset you want to deploy, select **Select ruleset**.

5. Give a name to the rule deploying the ruleset in **Execution name**.

6. (Optional) To execute the managed ruleset for a subset of incoming requests, select **Edit scope** and [configure the expression](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/edit-expressions/) that will determine the scope of the current rule deploying the managed ruleset.

   Warning

   Deployed rulesets will only apply to incoming traffic of Enterprise domains on your account. The Expression Builder will automatically include this filter. If you define a custom expression using the Expression Editor, use parentheses to enclose any custom conditions and end your expression with `and cf.zone.plan eq "ENT"` so that the rule only applies to domains on an Enterprise plan.

7. (Optional) You can customize the behavior of the managed ruleset in the following ways:

   * [Configure the entire ruleset](#configure-field-values-for-all-the-rules) (affects all the rules)
   * [Configure several rules or rules with specific tags](#configure-rules-in-bulk-in-a-managed-ruleset)
   * [Configure a single rule](#configure-a-single-rule-in-a-managed-ruleset)

8. To deploy the managed ruleset immediately, select **Deploy**. If you are not ready to deploy, select **Save as Draft**.

The **Deployed managed rulesets** list will show an *Execute* rule for the managed ruleset you deployed.

## Turn on or off a managed ruleset

Select the **Enabled** toggle next to a deployed managed ruleset to turn it on or off.

## Configure a managed ruleset

Configure a managed ruleset to define specific field values for one or more rules (for example, configure a rule with an action different from the action configured by Cloudflare). You can also turn off specific rules.

To skip one or more rules — or even entire WAF managed rulesets — for specific incoming requests, [add an exception](https://developers.cloudflare.com/waf/managed-rules/waf-exceptions/). Exceptions, also called skip rules, are shown as *Skip* rules in the **Deployed managed rulesets** list.

Note

Some managed rulesets may not allow custom configuration, depending on your Cloudflare plan.

### Configure field values for all the rules

To configure an entire managed ruleset:

1. In the Cloudflare dashboard, go to the **WAF** page.

   [Go to **WAF**](https://dash.cloudflare.com/?to=/:account/application-security/waf)

2. Go to the **Managed rulesets** tab.

3. Select the rule description of the *Execute* rule that deploys the managed ruleset you want to configure. Alternatively, select the three dots > **Edit**.

   If you have not deployed the managed ruleset yet, do the following:

   1. Select **Deploy** > **Deploy managed ruleset**.
   2. Next to the managed ruleset you want to deploy and configure, select **Select ruleset**.

4. In the ruleset configuration section, set one or more rule fields from the available values in the drop-down lists. The exact options vary according to the managed ruleset you are configuring.

   For example, select the action to perform for all the rules in the ruleset from the **Ruleset action** drop-down list.

   ![The Configure deployment page displaying the available options to override all the rules in the ruleset. In the displayed managed ruleset you can override the ruleset action.](https://developers.cloudflare.com/_astro/waf-configure-ruleset-account.YSsDcmI__21WwDr.webp)

5. If you are editing a deployed managed ruleset, select **Save**. If you have not deployed the managed ruleset yet, select **Deploy** to deploy the ruleset immediately, or **Save as Draft** to save your deployment settings for later.

### Configure rules in bulk in a managed ruleset

1. In the Cloudflare dashboard, go to the **WAF** page.

   [Go to **WAF**](https://dash.cloudflare.com/?to=/:account/application-security/waf)

2. Go to the **Managed rulesets** tab.

3. If you have already deployed the managed ruleset you want to configure, find the rule deploying that managed ruleset and select the rule description. Alternatively, select the three dots > **Edit** next to an *Execute* rule deploying the managed ruleset.

   If you have not deployed the managed ruleset:

   1. Select **Deploy** > **Deploy managed ruleset**.
   2. Next to the managed ruleset, select **Select ruleset**.

4. Select **Browse rules**.

   ![The Cloudflare dashboard displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

1) Search for rules using the available filters. You can search for tags.

2) In the results list, select the checkboxes for all the rules you want to configure.

   Alternatively, select a tag name under the search input to filter the rules with that tag, and then select the checkboxes for the rules you want to configure. To extend your selection to all rules with the tag across all pages, select **Select all \<NUMBER> rules**.

   ![Selecting all rules in a page displays additional drop-down lists above the table to override the behavior of several rules at once.](https://developers.cloudflare.com/_astro/waf-modify-selected-rules.DrTbw8v1_Z2aSCWH.webp)

3) Update one or more fields for the selected rules using the buttons displayed in the top right corner of the table.

4) Select **Next**.

5) If you selected a tag, a dialog appears asking you if any new rules with the selected tag should be configured with the field values you selected.

   * Select **Do not apply to new rules** to apply your configurations to the selected rules only.
   * Select **Apply to new rules** if you want to apply your configurations to any new rules with the select tag.

6) Select **Save**.

### Configure a single rule in a managed ruleset

1. In the Cloudflare dashboard, go to the **WAF** page.

   [Go to **WAF**](https://dash.cloudflare.com/?to=/:account/application-security/waf)

2. Go to the **Managed rulesets** tab.

3. If you have already deployed the managed ruleset you want to configure, find the rule deploying that managed ruleset and select the rule description. Alternatively, select the three dots > **Edit** next to an *Execute* rule deploying the managed ruleset.

   If you have not deployed the managed ruleset:

   1. Select **Deploy** > **Deploy managed ruleset**.
   2. Next to the managed ruleset, select **Select ruleset**.

4. Select **Browse rules**.

   ![The Cloudflare dashboard displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

1) Search for a rule using the available filters. You can search for tags.

2) Find the rule you want to configure in the results list.

3) In the result line for the rule you want to change, select the desired value for a field in the displayed drop-down lists. For example, select the rule action in the **Action** dropdown. You can also change the status of a rule using the **Status** toggle next to the rule.

4) Select **Next**, and then select **Save**.

### Browse the rules of a managed ruleset

You can browse the available rules in a managed ruleset and search for individual rules or tags.

1. In the Cloudflare dashboard, go to the **WAF** page.

   [Go to **WAF**](https://dash.cloudflare.com/?to=/:account/application-security/waf)

2. Go to the **Managed rulesets** tab.

3. Select the rule description of the *Execute* rule that deploys the managed ruleset you want to configure. Alternatively, select the three dots > **Edit**.

   If you have not deployed the managed ruleset yet, do the following:

   1. Select **Deploy** > **Deploy managed ruleset**.
   2. Next to the managed ruleset you want to browse, select **Select ruleset**.

4. Select **Browse rules**.

   ![The Browse rules page displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

### Delete a managed ruleset deployment rule or an exception

1. In the Cloudflare dashboard, go to the **WAF** page.

   [Go to **WAF**](https://dash.cloudflare.com/?to=/:account/application-security/waf)

2. Go to the **Managed rulesets** tab.

3. Under **Deployed managed rulesets** and next to the rule you want to delete, select the three dots > **Delete** and confirm the operation.
