---
title: Disable Universal SSL certificates · Cloudflare SSL/TLS docs
description: Some customers may need to manage their own SSL certificates or
  rely on specific Certificate Authorities.
lastUpdated: 2025-10-28T14:13:10.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/disable-universal-ssl/
  md: https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/disable-universal-ssl/index.md
---

Some customers may need to manage their own SSL certificates or rely on specific Certificate Authorities.

If you disable your domain's Universal SSL certificate, Cloudflare removes that certificate from our network and will not order or renew any additional Universal SSL certificates.

## Potential errors

To avoid errors with your domain, either [upload a custom certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/) or purchase [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) before disabling Universal SSL.

If you disable Universal SSL, you may experience errors with the following scenarios:

* **Enabled features**:

  * [HTTP Strict Transport Security (HSTS)](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/http-strict-transport-security/)
  * [Always Use HTTPS](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/always-use-https/)
  * [Opportunistic Encryption](https://developers.cloudflare.com/ssl/edge-certificates/additional-options/opportunistic-encryption/)

* **Other setups**:

  * [Page Rules](https://developers.cloudflare.com/rules/page-rules/) that redirect traffic to HTTPS
  * HTTP to HTTPS redirects at your origin web server

## Disable Universal SSL certificate

Before you disable Universal SSL/TLS, make sure you have [uploaded a custom certificate](https://developers.cloudflare.com/ssl/edge-certificates/custom-certificates/) or purchased [Advanced Certificate Manager](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/) to protect your domain.

* Dashboard

  To disable Universal SSL in the dashboard:

  1. In the Cloudflare dashboard, go to the **Edge Certificates** page.

     [Go to **Edge Certificates**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/edge-certificates)

  2. For **Disable Universal SSL**, select **Disable Universal SSL**.

  3. Read the warnings in the **Acknowledgement**.

  4. Select **I Understand** and select **Confirm**.

* API

  To disable Universal SSL with the Cloudflare API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/ssl/subresources/universal/subresources/settings/methods/edit/) request and include the `"enabled": false` parameter.

## Re-enable Universal SSL

* Dashboard

  To re-enable Universal SSL in the dashboard:

  1. In the Cloudflare dashboard, go to the **Edge Certificates** page.

     [Go to **Edge Certificates**](https://dash.cloudflare.com/?to=/:account/:zone/ssl-tls/edge-certificates)

  2. For **Disable Universal SSL**, select **Enable Universal SSL**.

* API

  To re-enable Universal SSL with the Cloudflare API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/ssl/subresources/universal/subresources/settings/methods/edit/) request and include the `"enabled": true` parameter.
