---
title: Configure Cloud Connector using Terraform · Cloudflare Rules docs
description: You can create Cloud Connector rules using the Terraform Cloudflare provider.
lastUpdated: 2025-04-03T17:29:23.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/cloud-connector/create-terraform/
  md: https://developers.cloudflare.com/rules/cloud-connector/create-terraform/index.md
---

You can create Cloud Connector rules using the [Terraform Cloudflare provider](https://registry.terraform.io/providers/cloudflare/cloudflare/latest).

To get started with Terraform for Cloudflare configuration, refer to [Terraform: Get started](https://developers.cloudflare.com/terraform/installing/).

## Required permissions

The [API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) used by Terraform must have at least the following permission:

* *Zone* > *Cloud Connector* > *Write*

## Example configuration

Note

Terraform code snippets below refer to the v4 SDK only.

The following example Terraform configuration creates Cloud Connector rules for various [supported providers](https://developers.cloudflare.com/rules/cloud-connector/providers/) to route traffic between them based on URI paths:

```tf
resource "cloudflare_cloud_connector_rules" "cloud_connector_rules" {
  zone_id = "<ZONE_ID>"


  rules {
    description = "Route /data to GCP bucket"
    enabled     = true
    expression  = "(http.request.uri.path wildcard \"*/data/*\")"
    provider    = "gcp_storage"
    parameters {
      host = "mystorage.storage.googleapis.com"
    }
  }


  rules {
    description = "Route /resources to AWS bucket"
    enabled     = true
    expression  = "(http.request.uri.path wildcard \"*/resources/*\")"
    provider    = "aws_s3"
    parameters {
      host = "mystorage.s3.ams.amazonaws.com"
    }
  }


  rules {
    description = "Route /files to Azure bucket"
    enabled     = true
    expression  = "(http.request.uri.path wildcard \"*/files/*\")"
    provider    = "azure_storage"
    parameters {
      host = "mystorage.blob.core.windows.net"
    }
  }


  rules {
    description = "Route /images to R2 bucket"
    enabled     = true
    expression  = "(http.request.uri.path wildcard \"*/images/*\")"
    provider    = "cloudflare_r2"
    parameters {
      host = "mybucketcustomdomain.example.com"
    }
  }
}
```

## More resources

Refer to the [Terraform Cloudflare provider documentation](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs) for more information on the `cloudflare_cloud_connector_rules` resource.
